<?php
if ( ! defined( 'ABSPATH' ) ) exit; 

if (!in_array('woocommerce', wpae_get_blocked_integrations())): 
    
    add_action( 'woocommerce_after_checkout_validation', 'wpae_woocommerce_extra_checkout_validation', 10, 2);

    function wpae_woocommerce_extra_checkout_validation( $fields, $errors) {
        if( empty( $errors->get_error_codes() ) ) {
            
            $wpa_checking = true;

            if (isset($_POST['payment_method']) && ($_POST['payment_method'] == 'ppec_paypal' )){
                $wpa_checking = false;
            }

            if ( isset($_POST['payment_request_type']) && ( ($_POST['payment_request_type'] == 'google_pay' ) || ($_POST['payment_request_type'] == 'apple_pay' ) ) ) {
                $wpa_checking = false;
            }

            if ($wpa_checking){
                if (wpa_check_is_spam($_POST)){
                    do_action('wpa_handle_spammers','woocommerce_checkout',$_POST);
                    $errors->add( 'validation',$GLOBALS['wpa_error_message'] );
                }
            }
            
        } 
        return $errors;
    }
    
    add_action( 'woocommerce_checkout_billing', 'wpae_woocommerce_add_initiator_field');
    function wpae_woocommerce_add_initiator_field( $checkout ) {
    	echo '<input type="hidden" id="wpae_initiator" class="wpae_initiator" name="wpae_initiator" value="" />';
    }

endif; // EOF BLOCK INTEGRATION CHECK


if (!in_array('woocommerce_register', wpae_get_blocked_integrations())):     
   
    add_filter( 'woocommerce_registration_errors', 'wpa_woocommerce_register_validation', 10, 3 );
      
    function wpa_woocommerce_register_validation( $errors, $username, $email ) {
        if (wpa_check_is_spam($_POST)){
            $errors->add( 'reg_email', $GLOBALS['wpa_error_message']);
        }    
        return $errors;
    }
    
    add_action( 'woocommerce_register_form', 'wpae_woocommerce_register_add_initiator_field');
    function wpae_woocommerce_register_add_initiator_field( $checkout ) {
        echo '<input type="hidden" id="wpae_initiator" class="wpae_initiator" name="wpae_initiator" value="" />';
    }

endif; // EOF BLOCK INTEGRATION CHECK