<?php
if ( ! defined( 'ABSPATH' ) ) exit; 

if (!in_array('woocommerce', wpae_get_blocked_integrations())): 
    
    add_action( 'woocommerce_after_checkout_validation', 'wpae_woocommerce_extra_checkout_validation', 10, 2);

    function wpae_woocommerce_extra_checkout_validation( $fields, $errors) {
        if ($_POST['payment_method'] != 'ppec_paypal'){ // CHECK SPAM ONLY IF NO EXPRESS PAYPAL CHECKOUT
            if (wpa_check_is_spam($_POST)){
                do_action('wpa_handle_spammers','woocommerce_checkout',$_POST);
                $errors->add( 'validation',$GLOBALS['wpa_error_message'] );
            }        
        }    
        return $errors;
    }

    add_filter( 'woocommerce_registration_errors', 'wpa_woocommerce_extra_validation', 10, 3 );
      
    function wpa_woocommerce_extra_validation( $errors, $username, $email ) {
        if (wpa_check_is_spam($_POST)){
            $errors->add( 'reg_email', $GLOBALS['wpa_error_message']);
        }    
        return $errors;
    }

    add_action( 'woocommerce_register_form', 'wpae_woocommerce_add_initiator_field');
    add_action( 'woocommerce_after_order_notes', 'wpae_woocommerce_add_initiator_field');
    function wpae_woocommerce_add_initiator_field( $checkout ) {
    	echo '<input type="hidden" id="wpae_initiator" class="wpae_initiator" name="wpae_initiator" value="" />';
    }

endif; // EOF BLOCK INTEGRATION CHECK