<?php wpae_check_license_status(); ?>
<?php
    global $wpdb;

    if (isset($_GET['action'])){
        switch ($_GET['action']) {
            case 'bulkdelete':
                    wpae_bulk_truncate('wpae_spam_data');
                    $actionReturn = array('status' => 'ok','body'=>'All Records Deleted' );
                break;
            case 'delete':
                    wpae_delete('wpae_spam_data','id = "'.$_GET['id'].'"');
                    $actionReturn = array('status' => 'ok','body'=>'1 Record Deleted' );
                break;
            case 'blockip':
                    wpae_insert('wpae_blocked_ip', array('spammer_ip' =>$_GET['ip']));
                    $actionReturn = array('status' => 'ok','body'=>$_GET['ip'].' Blocked' );
                break;
            case 'unblockip':
                    wpae_delete('wpae_blocked_ip','spammer_ip = "'.$_GET['ip'].'"');
                    $actionReturn = array('status' => 'ok','body'=>$_GET['ip'].' Unblocked' );
                break;
        }
    }

    $prefixed_wpae_spam_data       =   $wpdb->prefix . 'wpae_spam_data';
    $prefixed_wpae_blocked_ip      =   $wpdb->prefix . 'wpae_blocked_ip';
    isset($_GET['paged'])?$currentPage = $_GET['paged']:$currentPage = 1;
    $limit                  =   $GLOBALS['wpae_data_per_page'];
    
    $total_records          =   $wpdb->get_var( "SELECT COUNT(*) FROM $prefixed_wpae_spam_data");

    $num_pages              =   ceil($total_records / $limit) ;
    $offset                 =   ($currentPage - 1) * $limit;
    
    ;   
    $submission_details     =   $wpdb->get_results("SELECT spammer.*, blocked.id as blocked_id FROM $prefixed_wpae_spam_data as spammer left join $prefixed_wpae_blocked_ip as blocked ON spammer.spammer_ip = blocked.spammer_ip ORDER BY spammer.id DESC LIMIT $limit OFFSET $offset");    
    
?>

<?php if (isset($actionReturn)):?>
    <div class="updated <?php echo $actionReturn['status']; ?>" id="message"><p><?php echo $actionReturn['body']; ?></p></div>
<?php endif; ?>

<div class="wpae_pagination">
    <?php wpae_get_pagination_navigation('?page=wp-armour&tab=spam_data',$num_pages,$currentPage); ?>
</div>

<div class="wpae_bulk_actions">
    <a href="?page=wp-armour&tab=spam_data&paged=<?php echo $currentPage; ?>&action=bulkdelete" onclick="return confirm('Are you sure?')">Remove All Spam Submissions</a>
</div>
<div style="clear: both;"></div>

<table class="wp-list-table widefat">
    <thead>
    <tr>
        <th><strong>Sn</strong></th>
        <th><strong>Timestamp</strong></th>
        <th><strong>IP</strong></th>
        <th><strong>Source</strong></th>
        <th><strong>Actions</strong></th>
        <th><strong>Data tried to Submit</strong></th>
    </tr>
    </thead>
    <tbody>
        <?php 
        $cnt = $offset;
        if (!empty($submission_details)){
        foreach ($submission_details as $submission_detail): 
            $cnt++;
        ?>
            <tr>
                <td><?php echo $cnt; ?></td>
                <td><?php echo $submission_detail->updated_on; ?></td>
                <td><?php echo $submission_detail->spammer_ip; ?></td>
                <td><?php echo $submission_detail->wp_system; ?></td>
                <td>
                    <?php
                    if($submission_detail->blocked_id == null){ ?>
                    <a href="?page=wp-armour&tab=spam_data&paged=<?php echo $currentPage; ?>&action=blockip&ip=<?php echo $submission_detail->spammer_ip; ?>">Block IP</a> 
                    <?php } else { ?>
                        <a href="?page=wp-armour&tab=spam_data&paged=<?php echo $currentPage; ?>&action=unblockip&ip=<?php echo $submission_detail->spammer_ip; ?>">Unblock IP</a> 
                    <?php } ?> |
                    <a href="?page=wp-armour&tab=spam_data&paged=<?php echo $currentPage; ?>&action=delete&id=<?php echo $submission_detail->id; ?>">Delete</a>
                </td>
                <td>
                    <div class="submitted_spam_data">
                            <?php 
                            $spamDatas = json_decode($submission_detail->spam_data, true);
                            if (!empty($spamDatas)){
                                wpae_print_array($spamDatas);
                            } else {
                                echo 'No Data Available';
                            }
                            ?>
                        
                    </div>    
                </td>
            </tr>            
        <?php endforeach;
        } else { ?>
            <tr>
                <td colspan="6">No Records Found. May be you haven't enabled Spammer Submission Log ?</td>
            </tr>
        <?php } ?>
    </tbody>


</table>
<div class="wpae_pagination">
    <?php wpae_get_pagination_navigation('?page=wp-armour&tab=spam_data',$num_pages,$currentPage); ?>
</div>
<div class="wpae_bulk_actions">
    <a href="?page=wp-armour&tab=spam_data&action=bulkdelete" onclick="return confirm('Are you sure?')">Remove All Spam Submissions</a>
</div>
<div style="clear: both;"></div>