<div>
	<cx-vui-select
		label="<?php _e( 'Booking period', 'jet-booking' ); ?>"
		description="<?php _e( 'Define how the booking period will be calculated – per night (without the last booked date) or per day (including the last booked date).</br><b>Note:</b> this option will affect price calculation.', 'jet-booking' ); ?>"
		:options-list="[
			{
				value: 'per_nights',
				label: '<?php _e( 'Per Night (last booked date is not included)', 'jet-booking' ); ?>',
			},
			{
				value: 'per_days',
				label: '<?php _e( 'Per Day (last booked date is included)', 'jet-booking' ); ?>',
			}
		]"
		:wrapper-css="[ 'equalwidth' ]"
		:size="'fullwidth'"
		:value="configurationSettings.booking_period"
		@input="updateSetting( $event, 'booking_period' )"
	></cx-vui-select>

	<cx-vui-switcher
		label="<?php _e( 'Allow checkout only days', 'jet-booking' ); ?>"
		description="<?php _e( 'If this option is checked, the first day of the already booked period will be available for checkout only.', 'jet-booking' ); ?>"
		:wrapper-css="[ 'equalwidth' ]"
		v-if="'per_nights' === configurationSettings.booking_period"
		:value="configurationSettings.allow_checkout_only"
		@input="updateSetting( $event, 'allow_checkout_only' )"
	></cx-vui-switcher>

	<jet-abaf-settings-common-config
		:settings="settings"
		@force-update="updateChildSetting( $event )"
	></jet-abaf-settings-common-config>

	<cx-vui-component-wrapper
		label="<?php _e( 'End date', 'jet-booking' ); ?>"
		description="<?php _e( 'This option defines the latest date which is allowed for the user to pick.', 'jet-booking' ); ?>"
		:wrapper-css="[ 'equalwidth' ]"
	>
		<cx-vui-select
			:prevent-wrap="true"
			:options-list="[
				{
					value: 'none',
					label: '<?php _e( 'Any date', 'jet-booking' ); ?>'
				},
				{
					value: 'range',
					label: '<?php _e( 'Limited range', 'jet-booking' ); ?>'
				}
			]"
			:value="configurationSettings.end_date_type"
			@input="updateSetting( $event, 'end_date_type' )"
			:size="'fullwidth'"
			style="margin-bottom: 10px;"
		></cx-vui-select>

		<div
			v-if="'range' === configurationSettings.end_date_type"
			style="display: flex; gap: 5px;"
		>
			<cx-vui-input
				:prevent-wrap="true"
				type="number"
				min="1"
				:value="configurationSettings.end_date_range_number"
				@on-input-change="updateSetting( $event.target.value, 'end_date_range_number' )"
				style="width: 55px;"
			></cx-vui-input>

			<cx-vui-select
				:prevent-wrap="true"
				:options-list="[
					{
						value: 'day',
						label: '<?php _e( 'Day(s)', 'jet-booking' ); ?>'
					},
					{
						value: 'month',
						label: '<?php _e( 'Month(s)', 'jet-booking' ); ?>'
					},
					{
						value: 'year',
						label: '<?php _e( 'Year(s)', 'jet-booking' ); ?>'
					}
				]"
				:size="'fullwidth'"
				:value="configurationSettings.end_date_range_unit"
				@input="updateSetting( $event, 'end_date_range_unit' )"
				style="width: 100px;"
			></cx-vui-select>
		</div>
	</cx-vui-component-wrapper>

	<cx-vui-switcher
		label="<?php _e( 'Show price in calendar', 'jet-booking' ); ?>"
		description="<?php _e( 'If this option is checked, each date in the date-range picker will show its price.', 'jet-booking' ); ?>"
		:wrapper-css="[ 'equalwidth' ]"
		:value="configurationSettings.show_calendar_price"
		@input="updateSetting( $event, 'show_calendar_price' )"
	></cx-vui-switcher>
</div>
